#include <bits/stdc++.h>

using namespace std;

const int inf = 1e9;
const int N = 3010;
vector<int> g[N];
int n, k;
bool mark[N];
bool mark2[N];
int dist[N][N];
vector<pair<int, int>> edges;

void BFS(int u) {
    dist[u][u] = 0;
    queue<int> q;
    for(int i = 1; i <= n; i++) mark[i] = false;
    q.push(u);
    while(!q.empty()) {
        int x = q.front();
        q.pop();
        mark[x] = true;
        for(int v : g[x]) {
            if(mark[v]) continue;
            q.push(v);
            dist[u][v] = min(dist[u][v], dist[u][x] + 1);
        }
    }
}

int dp[N];
int len[N];

void dfs(int u, int avoid) {
    if(mark[u]) return;
    mark[u] = true;
    for(int v : g[u]) {
        if(v == avoid) continue;
        if(mark[v]) continue;
        dfs(v, avoid);
        dp[u] = max(dp[u], dp[v] + 1);
    }
}

void dfs2(int u, int avoid) {
    if(mark2[u]) return;
    mark2[u] = true;
    int mx = -1, mx2 = -1;
    for(int v : g[u]) {
        if(v == avoid) continue;
        if(mark2[v]) continue;
        dfs2(v, avoid);
        mx2 = max(mx2, dp[v]);
        if(mx < mx2) swap(mx, mx2);
    }
    vector<int> vec;
    if(mx != -1) vec.push_back(mx);
    if(mx2 != -1) vec.push_back(mx2);
    if(vec.size() == 0) return;
    if(vec.size() == 1) {
        len[u] = vec[0] + 1;
        return;
    }
    len[u] = vec[0] + vec[1] + 2;
}

int get_diametar(int u, int avoid) {
    dfs(u, avoid);
//    cout << u << " " << avoid << "\n";
//    for(int i = 1; i <= n; i++) cout << dp[i] << "
//    cout << "\n";
    dfs2(u, avoid);
//    for(int i = 1; i <= n; i++) cout << len[i] << " ";
//    cout << "\n";
    int ret = 0;
    for(int i = 1; i <= n; i++) ret = max(ret, len[i]);
    return ret;
}

void solve() {
    cin >> n >> k;
    for(int i = 1; i <= n; i++) {
        g[i].clear();
        for(int j = 1; j <= n; j++) dist[i][j] = inf;
        mark[i] = false;
        mark2[i] = false;
        dp[i] = 0;
        len[i] = 0;
    }
    for(int i = 1; i < n; i++) {
        int u, v;
        cin >> u >> v;
        edges.push_back({u, v});
        g[u].push_back(v);
        g[v].push_back(u);
    }
    if(k == 0) {
        for(int i = 1; i <= n; i++) BFS(i);
        int diam = 0;
        for(int i = 1; i <= n; i++) for(int j = 1; j <= n; j++) diam = max(diam, dist[i][j]);
        cout << diam << "\n";
        return;
    }
    if(k == 1) {
        int res = 0;
        for(int i = 0; i < edges.size(); i++) {
            for(int j = 1; j <= n; j++) {
                mark[j] = mark2[j] = false;
                dp[j] = len[j] = 0;
            }
            int sum = 0;
            int xx = get_diametar(edges[i].second, edges[i].first);
            for(int j = 1; j <= n; j++) {
                mark[j] = mark2[j] = false;
                dp[j] = len[j] = 0;
            }
            int yy = get_diametar(edges[i].first, edges[i].second);
            sum = xx + yy + 1;
//            cout << xx << " " << yy << " " << edges[i].first << " " << edges[i].second << "\n";
            res = max(res, sum);
        }
        cout << res << "\n";
        return;
    }
    if(n <= 20) {

        return;
    }
    cout << "ako ste ga namerno stavili za najtezi svesno ste naneli bol desetinama takmicara";
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    int tt;
    cin >> tt;
    while(tt--) solve();
    return 0;
}